uniform sampler2D texture0;	// depth texture
uniform sampler2D texture1;	// screen

uniform vec2 camerarange; 	// near and far camera range
uniform vec2 screensize;	// screen width and height

varying vec2 texCoord;

//vec3			hlf=vec3(0.5,0.5,0.5);

float readDepth( vec2 coord ) {
	return ((2.0 * camerarange.x) / (camerarange.y + camerarange.x - texture2D( texture0, coord ).x * (camerarange.y - camerarange.x)));	
}

float compareDepths( in float depth1, in float depth2 ) {
	float aoCap = 1.0;
	float aoMultiplier=100000000.0;
	float depthTolerance=0.00000;
	float aorange = 0.0001;// units in space the AO effect extends to (this gets divided by the camera far range
	float diff = sqrt( clamp(  1.0  -  (depth1-depth2) / ( aorange / (camerarange.y-camerarange.x) ),0.5,1.0) );
	float ao = min(aoCap,max(0.0,depth1-depth2-depthTolerance) * aoMultiplier) * diff;
	return ao;
}

void main(void)
{	
	float depth = readDepth( texCoord );
	float d;
	
	float pw = 1.0 / screensize.x;
	float ph = 1.0 / screensize.y;

	float aoCap = 1.0;

	float ao = 0.0;
	
	float aoMultiplier=99999999.0;

	float depthTolerance = 0.001;
	
	float aoscale=0.5;

/*for(int i=0;i<2;i++)
{*/
	d=readDepth( vec2(texCoord.x+pw,texCoord.y+ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y+ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x+pw,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;
	
	pw*=2.0;
	ph*=2.0;
	//aoMultiplier/=1.0;
	aoscale*=1.2;
	
	d=readDepth( vec2(texCoord.x+pw,texCoord.y+ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y+ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x+pw,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	pw*=2.0;
	ph*=2.0;
	//aoMultiplier/=1.0;
	aoscale*=1.2;
	
	d=readDepth( vec2(texCoord.x+pw,texCoord.y+ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y+ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x+pw,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;
	
	pw*=2.0;
	ph*=2.0;
	//aoMultiplier/=1.0;
	aoscale*=1.2;
	
	d=readDepth( vec2(texCoord.x+pw,texCoord.y+ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y+ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x+pw,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	pw = 1.0 / screensize.x;
	ph = 1.0 / screensize.y;

	pw*=2.0;
	ph*=2.0;
	//aoMultiplier/=1.0;
	aoscale*=1.2;

	d=readDepth( vec2(texCoord.x+pw,texCoord.y));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;
	
	pw*=2.0;
	ph*=2.0;
	//aoMultiplier/=1.0;
	aoscale*=1.2;
	
	d=readDepth( vec2(texCoord.x+pw,texCoord.y));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	pw*=2.0;
	ph*=2.0;
	//aoMultiplier/=1.0;
	aoscale*=1.2;
	
	d=readDepth( vec2(texCoord.x+pw,texCoord.y));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;
	
	pw*=2.0;
	ph*=2.0;
	//aoMultiplier/=1.0;
	aoscale*=1.2;
	
	d=readDepth( vec2(texCoord.x+pw,texCoord.y));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x-pw,texCoord.y));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

	d=readDepth( vec2(texCoord.x,texCoord.y-ph));
	ao+=compareDepths(depth,d)/aoscale;

//	}
	ao/=32.0;
	//ao*=ao;
	ao=1.0-ao;
	gl_FragColor = vec4(ao); //vec4(1.0-ao);// * texture2D(texture1,texCoord);
}